#define _QCAP_LABVIEW_IMPORT
typedef int                 BOOL;
#define FALSE 0
#define TRUE 1
typedef int INT;
#include <QDebug>
#include <qfiledialog.h>

#include "animationfactorydlg.h"
#include "ui_animationfactorydlg.h"

#include "QCAP.H"

AnimationFactoryDlg * g_pAnimationFactoryDlg = NULL;

QRETURN on_process_signal_removed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    ULONG i = (ULONG)(pUserData);

    qDebug( "on_no_signal_removed_callback( ch%d )", i+1 );

    g_pAnimationFactoryDlg->m_nVideoWidth[ i ] = 0;

    g_pAnimationFactoryDlg->m_nVideoHeight[ i ] = 0;

    g_pAnimationFactoryDlg->m_nAudioChannels[ i ] = 0;

    g_pAnimationFactoryDlg->m_nAudioBitsPerSample[ i ] = 0;

    g_pAnimationFactoryDlg->m_nAudioSampleFrequency[ i ] = 0;

    return QCAP_RT_OK;
}

QRETURN on_process_no_signal_detected( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, PVOID pUserData )
{
    ULONG i = (ULONG)(pUserData);

    qDebug( "on_no_signal_detected_callback( ch%d )", i+1 );

    g_pAnimationFactoryDlg->m_nVideoWidth[ i ] = 0;

    g_pAnimationFactoryDlg->m_nVideoHeight[ i ] = 0;

    g_pAnimationFactoryDlg->m_nAudioChannels[ i ] = 0;

    g_pAnimationFactoryDlg->m_nAudioBitsPerSample[ i ] = 0;

    g_pAnimationFactoryDlg->m_nAudioSampleFrequency[ i ] = 0;

    return QCAP_RT_OK;
}

QRETURN on_process_format_changed( PVOID pDevice, ULONG nVideoInput, ULONG nAudioInput, ULONG nVideoWidth, ULONG nVideoHeight, BOOL bVideoIsInterleaved, double dVideoFrameRate, ULONG nAudioChannels, ULONG nAudioBitsPerSample,  ULONG nAudioSampleFrequency, PVOID pUserData )
{
    ULONG i = (ULONG)(pUserData);

    qDebug( "on_format_changed_callback( ch%d, %d, %d, %d, %d, %d )", i+1, nVideoWidth, nVideoHeight, nAudioChannels, nAudioBitsPerSample, nAudioSampleFrequency );

    g_pAnimationFactoryDlg->m_nVideoWidth[ i ] = nVideoWidth;

    g_pAnimationFactoryDlg->m_nVideoHeight[ i ] = nVideoHeight;

    g_pAnimationFactoryDlg->m_bVideoIsInterleaved[ i ] = bVideoIsInterleaved;

    g_pAnimationFactoryDlg->m_dVideoFrameRate[ i ] = dVideoFrameRate;

    g_pAnimationFactoryDlg->m_nAudioChannels[ i ] = nAudioChannels;

    g_pAnimationFactoryDlg->m_nAudioBitsPerSample[ i ] = nAudioBitsPerSample;

    g_pAnimationFactoryDlg->m_nAudioSampleFrequency[ i ] = nAudioSampleFrequency;

    return QCAP_RT_OK;
}

QRETURN on_video_preview_callback( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    return QCAP_RT_OK;
}

QRETURN on_process_preview_audio_buffer( PVOID pDevice, double dSampleTime, BYTE* pFrameBuffer, ULONG nFrameBufferLen, PVOID pUserData)
{
    ULONG i = (ULONG)(pUserData);

    if( i == 0 ) {

        EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection_audio );

        if( g_pAnimationFactoryDlg->m_nShareRecordState_audio > 0x00000000 ) {

            QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, pFrameBuffer, nFrameBufferLen );
        }
        LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection_audio );
    }

    return (QRETURN)(QCAP_RT_SKIP_DISPLAY | QCAP_RT_SKIP_CLONE_DISPLAY);
}

QRETURN on_video_share_record_media_timer_callback( UINT iRecNum, double dSampleTime, double dDelayTime, PVOID pUserData  )
{
	EnterCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );

	if( g_pAnimationFactoryDlg->m_nShareRecordState > 0x00000000 ) {

		UINT   iFrameNum = 0;

		BYTE * pClipFrameBuffer = NULL;

		ULONG  nClipFrameBufferLen = 0;

		QCAP_STEP_ANIMATION_CLIP( g_pAnimationFactoryDlg->m_pClip, &iFrameNum, &pClipFrameBuffer, &nClipFrameBufferLen );

		if( pClipFrameBuffer ) {

			QCAP_SET_VIDEO_SHARE_RECORD_UNCOMPRESSION_BUFFER( 0, g_pAnimationFactoryDlg->m_nClipColorSpaceType, 
				
																 g_pAnimationFactoryDlg->m_nClipWidth, 
																 
																 g_pAnimationFactoryDlg->m_nClipHeight, 
																 
																 pClipFrameBuffer, 
																 
																 nClipFrameBufferLen );
		}
	}
	LeaveCriticalSection( &g_pAnimationFactoryDlg->m_hShareRecordAccessCriticalSection );

	return QCAP_RT_OK;
}

AnimationFactoryDlg::AnimationFactoryDlg(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::AnimationFactoryDlg)
{
    ui->setupUi(this);

    g_pAnimationFactoryDlg = this;

    this->setWindowTitle("SC510N4 ANIMATION");

    this->setMinimumSize(530,460);

    this->setMaximumSize(530,460);

    ui->pushButton_XML->setEnabled(false);

    ui->pushButton_start->setEnabled(false);

    ui->pushButton_stop->setEnabled(false);

    //INITIALIZE MEMBER VARIABLES

    for(ULONG i = 0 ; i < 4 ; i++ )
    {
        m_hVideoDevice[ i ] = NULL;

        m_nVideoWidth[ i ] = 0;

        m_nVideoHeight[ i ] = 0;

        m_bVideoIsInterleaved[ i ] = 0;

        m_dVideoFrameRate[ i ] = 0;

        m_nAudioChannels[ i ] = 0;

        m_nAudioBitsPerSample[ i ] = 0;

        m_nAudioSampleFrequency[ i ] = 0;
    }

    m_pClip = NULL;

    m_nClipFrame = 0;

    m_nClipSprite = 0;

    m_nClipColorSpaceType = 0;

    m_nClipWidth = 0;

    m_nClipHeight = 0;

    m_bIsShareRecord = false;

    m_nShareRecordState_audio = 0x00000000;

    m_nShareRecordState_video = 0x00000000;

    InitializeCriticalSection( &m_hShareRecordAccessCriticalSection_audio );

    InitializeCriticalSection( &m_hShareRecordAccessCriticalSection_video );

    HwInitialize();
}

AnimationFactoryDlg::~AnimationFactoryDlg()
{
    HwUninitialize();

    delete ui;
}

void AnimationFactoryDlg::HwInitialize()
{
    //CREATE CAPTURE DEVICE

    QCAP_CREATE( "SA7160 PCI", 0, (HWND)ui->ChannelWindow0->winId(), &m_hVideoDevice[0], TRUE);

    QCAP_CREATE( "SA7160 PCI", 1, (HWND)ui->ChannelWindow1->winId(), &m_hVideoDevice[1], TRUE);

    QCAP_CREATE( "SA7160 PCI", 2, (HWND)ui->ChannelWindow2->winId(), &m_hVideoDevice[2], TRUE);

    QCAP_CREATE( "SA7160 PCI", 3, (HWND)ui->ChannelWindow3->winId(), &m_hVideoDevice[3], TRUE);

    for( ULONG i = 0 ; i < 4 ; i++ )
    {
        QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK( m_hVideoDevice[ i ], on_process_no_signal_detected, (PVOID)i );

        QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK( m_hVideoDevice[ i ], on_process_signal_removed, (PVOID)i );

        QCAP_REGISTER_FORMAT_CHANGED_CALLBACK( m_hVideoDevice[ i ], on_process_format_changed, (PVOID)i );

        QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], on_video_preview_callback, (PVOID)i );

        QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK( m_hVideoDevice[ i ], on_process_preview_audio_buffer, (PVOID)i );

        QCAP_SET_VIDEO_INPUT( m_hVideoDevice[ i ], QCAP_INPUT_TYPE_AUTO );

        QCAP_SET_AUDIO_INPUT( m_hVideoDevice[ i ], QCAP_INPUT_TYPE_EMBEDDED_AUDIO );

        QCAP_SET_AUDIO_VOLUME( m_hVideoDevice[ i ], 0 );

        QCAP_SET_VIDEO_DEINTERLACE( m_hVideoDevice[ i ], 1 );

        QCAP_RUN( m_hVideoDevice[ i ] );
    }

    QCAP_SET_OSD_TEXT(m_hVideoDevice[ 0 ], 0, 50, 50, 0, 0, "CH01", "Arial", QCAP_FONT_STYLE_BOLD, 100, 0xFFFF0000, 0xFFFFFFFF, 128, 0, 0, QCAP_SEQUENCE_STYLE_FOREMOST);

    if( m_hVideoDevice[0] || m_hVideoDevice[1] || m_hVideoDevice[2] || m_hVideoDevice[3] )
    {
        ui->pushButton_XML->setEnabled(true);
    }
}

void AnimationFactoryDlg::HwUninitialize()
{
    //DESTROY CAPTURE DEVICE

    on_pushButton_stop_clicked();

    for( ULONG i = 0 ; i < 4 ; i++ )
    {
        if( m_hVideoDevice[ i ] ) {

            QCAP_STOP( m_hVideoDevice[ i ] );

            QCAP_DESTROY( m_hVideoDevice[ i ] );

            m_hVideoDevice[ i ] = NULL;
        }
    }

    DeleteCriticalSection( &m_hShareRecordAccessCriticalSection_audio );

    DeleteCriticalSection( &m_hShareRecordAccessCriticalSection_video );

    CoUninitialize();
}

void AnimationFactoryDlg::on_pushButton_XML_clicked()
{
    FilePath = QFileDialog::getOpenFileName(this,"open XML file",".", "XML files (*.xml)");

    FilePath_ByteArray = FilePath.toLocal8Bit();

    psz = FilePath_ByteArray.data();

    if( strlen(psz) > 0 )
    {
        ui->pushButton_start->setEnabled(true);

        ui->lineEdit_XML->setText(FilePath);
    }
}

void AnimationFactoryDlg::on_pushButton_start_clicked()
{
    QCAP_CREATE_ANIMATION_CLIP( psz, &m_pClip, &m_nClipFrame, &m_nClipSprite, &m_nClipColorSpaceType, &m_nClipWidth, &m_nClipHeight );

    //    QCAP_SET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY( m_pClip, 0, 0, 100, 200, 320, 180 );

    //    QCAP_SET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY( m_pClip, 0, 0, 0 );

    //    for( ULONG i = 0 ; i < m_nClipSprites ; i++ ) {

    //        for( ULONG j = 0 ; j < m_nClipFrames ; j++ ) {

    //            INT    x = 0;

    //            INT    y = 0;

    //            INT    w = 0;

    //            INT    h = 0;

    //            double a = 0;

    //            QCAP_GET_ANIMATION_CLIP_SPRITE_TRANSFORM_PROPERTY( m_pClip, i, j, &x, &y, &w, &h );

    //            QCAP_GET_ANIMATION_CLIP_SPRITE_ALPHA_PROPERTY( m_pClip, i, j, &a );

    //            SC_DEBUG( "%d %d %d %d %d %d %f", i, j, x, y, w, h, a );
    //        }
    //    }
    QCAP_START_ANIMATION_CLIP( m_pClip );

    QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClip, 0, m_hVideoDevice[ 0 ] );

    QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClip, 1, m_hVideoDevice[ 1 ] );

    QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClip, 2, m_hVideoDevice[ 2 ] );

    QCAP_SET_ANIMATION_CLIP_SPRITE_SOURCE( m_pClip, 3, m_hVideoDevice[ 3 ] );

    if( m_pClip )
    {
        QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, QCAP_ENCODER_FORMAT_H264, m_nClipColorSpaceType, m_nClipWidth, m_nClipHeight, 30, QCAP_RECORD_MODE_CBR, 8000, 8000000, 30, 0, 0, (HWND)ui->DisplayWindow->winId(), TRUE, FALSE);

        QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY( 0, QCAP_ENCODER_TYPE_SOFTWARE, QCAP_ENCODER_FORMAT_AAC, m_nAudioChannels[ 0 ], m_nAudioBitsPerSample[ 0 ], m_nAudioSampleFrequency[ 0 ], 100 );

		QCAP_REGISTER_VIDEO_SHARE_RECORD_MEDIA_TIMER_CALLBACK( 0, on_video_share_record_media_timer_callback, (PVOID)0);

        QCAP_START_SHARE_RECORD( 0, "", QCAP_RECORD_FLAG_DISPLAY | QCAP_RECORD_FLAG_VIDEO_USE_MEDIA_TIMER | QCAP_RECORD_FLAG_AUDIO_USE_MEDIA_TIMER );

        EnterCriticalSection( &m_hShareRecordAccessCriticalSection_audio );

        m_nShareRecordState_audio = 0x00000001;

        LeaveCriticalSection( &m_hShareRecordAccessCriticalSection_audio );

        EnterCriticalSection( &m_hShareRecordAccessCriticalSection_video );

        m_nShareRecordState_video = 0x00000001;

        LeaveCriticalSection( &m_hShareRecordAccessCriticalSection_video );

        m_bIsShareRecord = true;

        ui->pushButton_start->setEnabled(false);

        ui->pushButton_stop->setEnabled(true);
    }
}

void AnimationFactoryDlg::on_pushButton_stop_clicked()
{
    if( m_bIsShareRecord == true)
    {
        EnterCriticalSection( &m_hShareRecordAccessCriticalSection_audio );

        m_nShareRecordState_audio = 0x00000000;

        LeaveCriticalSection( &m_hShareRecordAccessCriticalSection_audio );

        EnterCriticalSection( &m_hShareRecordAccessCriticalSection_video );

        m_nShareRecordState_video = 0x00000000;

        LeaveCriticalSection( &m_hShareRecordAccessCriticalSection_video );

        QCAP_STOP_SHARE_RECORD( 0 );

        if( m_pClip )
        {
            QCAP_STOP_ANIMATION_CLIP( m_pClip );

            QCAP_DESTROY_ANIMATION_CLIP( m_pClip );

            m_pClip = NULL;
        }

        m_bIsShareRecord == false;

        ui->pushButton_start->setEnabled(true);

        ui->pushButton_stop->setEnabled(false);
    }
}
